/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXSCENE_H
#define QKNXSCENE_H

#include <QtKnx/qknxdatapointtype.h>
#include <QtKnx/qtknxglobal.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxSceneNumber : public QKnxFixedSizeDatapointType
{
public:
    QKnxSceneNumber();
    QKnxSceneNumber(quint8 number);

    static const constexpr int TypeSize = 0x01;
    static const constexpr int MainType = 0x11;
    static const constexpr int SubType = 0x01;

    quint8 sceneNumber() const;
    bool setSceneNumber(quint8 number);

    bool isValid() const override;
};

class Q_KNX_EXPORT QKnxSceneControl : public QKnxFixedSizeDatapointType
{
    Q_GADGET

public:
    enum Control : quint8
    {
        Activate = 0x00,
        Learn = 0x01
    };
    Q_ENUM(Control)

    QKnxSceneControl();
    QKnxSceneControl(quint8 sceneNumber, Control control);

    static const constexpr int TypeSize = 0x01;
    static const constexpr int MainType = 0x12;
    static const constexpr int SubType = 0x01;

    quint8 sceneNumber() const;
    bool setSceneNumber(quint8 number);

    Control control() const;
    bool setControl(Control control);

    bool isValid() const override;
    bool setValue(quint8 sceneNumber, Control control);
};

class Q_KNX_EXPORT QKnxSceneInfo : public QKnxFixedSizeDatapointType
{
    Q_GADGET

public:
    enum Info : quint8
    {
        Active = 0x00,
        Inactive = 0x01
    };
    Q_ENUM(Info)

    QKnxSceneInfo();
    QKnxSceneInfo(quint8 sceneNumber, Info info);

    static const constexpr int TypeSize = 0x01;
    static const constexpr int MainType = 0x1a;
    static const constexpr int SubType = 0x01;

    quint8 sceneNumber() const;
    bool setSceneNumber(quint8 number);

    Info info() const;
    bool setInfo(Info info);

    bool isValid() const override;
    bool setValue(quint8 sceneNumber, Info info);
};

QT_END_NAMESPACE

#endif
